/* ------------------------------------------------------------------------
   Function:

   Author:
      P.Power   (july 2010)

   Modifications:

   Register usage map:

   ------------------------------------------------------------------------ */
.file    "ctimer_set.s";


// ------------------------------------------------------------------------
.section .text;
.type    _e_ctimer_set, %function;
.global  _e_ctimer_set;

.balign 4;
_e_ctimer_set:

        and   r0, r0, r0;                    // set the status to check which timer register
    //----
        beq   _ctimer0_set;                  // jump to code for timer0


.balign 4;
_ctimer1_set:

        movfs r3, config;                    // get the current config setting
    //----
        mov   r0, %low(0xfffff0ff);          // load mask for the config register
    //----
        movt  r0, %high(0xfffff0ff);         // load mask for the config register
    //----
        lsl   r1, r1, 0x8;                   // the ctimer1 control bits start at bit8
    //----
        and   r3, r3, r0;                    // apply the mask to clear TIMERMODE bits from previous config setting
    //----
        movts config, r3;                    // turn the ctimer1 off
    //----
        orr   r3, r3, r1;                    // add the desired TIMERMODE to config
    //----
        movts ctimer1, r2;                   // set the ctimer counter to the desired value
    //----
        movts config, r3;                    // start the ctimer counter
    //----
        movfs r0, ctimer1;                   // read the ctimer value
    //----
        rts;                                 // return with the current value of the ctimer


.balign 4;
_ctimer0_set:

        movfs r3, config;                    // get the current config setting
    //----
        mov   r0, %low(0xffffff0f);          // load mask for the config register
    //----
        movt  r0, %high(0xffffff0f);         // load mask for the config register
    //----
        lsl   r1, r1, 0x4;                   // the ctimer0 control bits start at bit4
    //----
        and   r3, r3, r0;                    // apply the mask to clear TIMERMODE bits from previous config setting
    //----
        movts config, r3;                    // turn the ctimer0 off
    //----
        orr   r3, r3, r1;                    // add the desired TIMERMODE to config
    //----
        movts ctimer0, r2;                   // set the ctimer counter to the desired value
    //----
        movts config, r3;                    // start the ctimer counter
    //----
        movfs r0, ctimer0;                   // read the ctimer value
    //----
        rts;                                 // return with the current value of the ctimer

.size    _e_ctimer_set, .-_e_ctimer_set;


/* ------------------------------------------------------------------------
   End of File
   ------------------------------------------------------------------------ */

