#!/bin/bash

echo "Building FIR benchmark..."

   e-gcc -Wall -O3 -std=c99 \
         -mlong-calls \
         -mfp-mode=round-nearest \
         -ffp-contract=fast \
         -funroll-loops \
         -T ${EPIPHANY_HOME}/bsps/emek3/fast.ldf \
         -o ./fir.elf \
         ./fir.c


echo "Building IIR benchmark..."

   e-gcc -Wall -O3 -std=c99 \
         -mlong-calls \
         -mfp-mode=round-nearest \
         -ffp-contract=fast \
         -ffast-math \
         -funroll-loops \
         -T ${EPIPHANY_HOME}/bsps/emek3/fast.ldf \
         -o ./iir.elf \
         ./iir.c


echo "Building MATMUL benchmark..."

   e-gcc -Wall -O3 -std=c99 \
         -mlong-calls \
         -mfp-mode=round-nearest \
         -ffp-contract=fast \
         -ffast-math \
         -funroll-loops \
         -T ${EPIPHANY_HOME}/bsps/emek3/fast.ldf \
         -o ./matmul.elf \
         ./matmul.c


echo "Building DOTPROD benchmark..."

   e-gcc -Wall -O3 -std=c99 \
         -mlong-calls \
         -mfp-mode=round-nearest \
         -ffp-contract=fast \
         -ffast-math \
         -funroll-loops \
         -T ${EPIPHANY_HOME}/bsps/emek3/fast.ldf \
         -o ./dotprod.elf \
         ./dotprod.c


