#!/bin/bash

###########################################################
# script configuration
BUILD_CONFIGURATION=Release
MAT_X=32
MAT_Y=36
MAT_NX=4
MAT_NY=4
let MAT_CX=MAT_X+MAT_NX-1
let MAT_CY=MAT_Y+MAT_NY-1
basename=EpFaceCore
hostpath=EpFaceHost

LDF=/opt/adapteva/esdk/bsps/emek3/fast.ldf
HOST_INCLUDE=/opt/adapteva/esdk/tools/host/x86_64/include
HOST_LIB=/opt/adapteva/esdk/tools/host/x86_64/lib
###########################################################

echo
echo "Building cores in $BUILD_CONFIGURATION configuration"
echo "===================================================="

if [ "$BUILD_CONFIGURATION" == "Debug" ]; then 
  OPTS="-O0 -g3 -Wall -c -fmessage-length=0 -ffp-contract=fast -mlong-calls -mfp-mode=round-nearest -MMD -MP"
else
  OPTS="-O3 -g0 -Wall -c -fmessage-length=0 -ffp-contract=fast -mlong-calls -mfp-mode=round-nearest -MMD -MP"
fi

cd ${basename}_commonlib
rm -rf $BUILD_CONFIGURATION
mkdir -p $BUILD_CONFIGURATION
e-gcc $OPTS -std=c99 -MF"$BUILD_CONFIGURATION/device_cascade_detector.d" -MT"$BUILD_CONFIGURATION/device_cascade_detector.d" -o "$BUILD_CONFIGURATION/device_cascade_detector.o" "src/device_cascade_detector.c"
e-ar -r "$BUILD_CONFIGURATION/lib${basename}_commonlib.a"  $BUILD_CONFIGURATION/device_cascade_detector.o
cd - > /dev/null

for CUR_X in `seq $MAT_X $MAT_CX`;
do
    for CUR_Y in `seq $MAT_Y $MAT_CY`;
    do
        CUR_CORE=${basename}.core.${CUR_X}_${CUR_Y}
        cd $CUR_CORE
        rm -rf $BUILD_CONFIGURATION
        mkdir -p $BUILD_CONFIGURATION
        e-gcc $OPTS -MF"$BUILD_CONFIGURATION/coordinates.d" -MT"$BUILD_CONFIGURATION/coordinates.d" -o "$BUILD_CONFIGURATION/coordinates.o" "src/coordinates.c"
        e-gcc $OPTS -MF"$BUILD_CONFIGURATION/main.d" -MT"$BUILD_CONFIGURATION/main.d" -o "$BUILD_CONFIGURATION/main.o" "src/main.c"
        e-gcc -L"../${basename}_commonlib/$BUILD_CONFIGURATION" -T $LDF -o "$BUILD_CONFIGURATION/$CUR_CORE.elf"  $BUILD_CONFIGURATION/coordinates.o $BUILD_CONFIGURATION/main.o -l${basename}_commonlib
        cd - > /dev/null
    done
done

cd ${basename}
rm -rf $BUILD_CONFIGURATION
mkdir -p Cores
ALL_CORES=""
for CUR_X in `seq $MAT_X $MAT_CX`;
do
    for CUR_Y in `seq $MAT_Y $MAT_CY`;
    do
        CUR_CORE=${basename}.core.${CUR_X}_${CUR_Y}
	core_id=$(printf '%x' $((${CUR_X}*64+${CUR_Y})))
        e-objcopy --coreid ${core_id} --srec-forceS3 --output-target srec "../$CUR_CORE/$BUILD_CONFIGURATION/$CUR_CORE.elf" "Cores/$CUR_CORE.srec"
	ALL_CORES="$ALL_CORES Cores/$CUR_CORE.srec"
    done
done
cat  $ALL_CORES  > Cores/${basename}.srec
cd - > /dev/null

echo
echo "Building host (device + emulation) in ${hostpath}"
echo "===================================================="

cd ${hostpath}
rm -rf $BUILD_CONFIGURATION
mkdir -p $BUILD_CONFIGURATION
mkdir -p "$BUILD_CONFIGURATION/c"
mkdir -p "$BUILD_CONFIGURATION/cpp"
if [ "$BUILD_CONFIGURATION" == "Debug" ]; then 
  OPTS="-O0 -g3 -Wall -c -fmessage-length=0 -fopenmp -MMD -MP"
else
  OPTS="-O3 -g0 -Wall -c -fmessage-length=0 -fopenmp -MMD -MP"
fi

echo "Building for device mode..."

g++ -D__HOST__ -I${HOST_INCLUDE} ${OPTS} -MF"$BUILD_CONFIGURATION/cpp/ep_cascade_detector.d" -MT"$BUILD_CONFIGURATION/cpp/ep_cascade_detector.d" -o "$BUILD_CONFIGURATION/cpp/ep_cascade_detector.o" "cpp/ep_cascade_detector.cpp"
gcc -D__HOST__ -I${HOST_INCLUDE} ${OPTS} -std=c99 -MF"$BUILD_CONFIGURATION/c/ep_cascade_detector.d" -MT"$BUILD_CONFIGURATION/c/ep_cascade_detector.d" -o "$BUILD_CONFIGURATION/c/ep_cascade_detector.o" "c/ep_cascade_detector.c"
gcc -D__HOST__ -I${HOST_INCLUDE} ${OPTS} -std=c99 -MF"$BUILD_CONFIGURATION/c/ep_emulator.d" -MT"$BUILD_CONFIGURATION/c/ep_emulator.d" -o "$BUILD_CONFIGURATION/c/ep_emulator.o" "c/ep_emulator.c"
g++ -D__HOST__ -I${HOST_INCLUDE} ${OPTS} -MF"$BUILD_CONFIGURATION/main.d" -MT"$BUILD_CONFIGURATION/main.d" -o "$BUILD_CONFIGURATION/main.o" "main.cpp"
g++ -L${HOST_LIB} -z origin -fopenmp -o "$BUILD_CONFIGURATION/EpFaceHost"  ./$BUILD_CONFIGURATION/cpp/ep_cascade_detector.o  ./$BUILD_CONFIGURATION/c/ep_cascade_detector.o ./$BUILD_CONFIGURATION/c/ep_emulator.o  ./$BUILD_CONFIGURATION/main.o   -lopencv_core -lopencv_highgui -lopencv_imgproc -lopencv_objdetect -le_host

echo "Building for emulation mode..."

g++ -D__HOST__ -DDEVICE_EMULATION -I${HOST_INCLUDE} ${OPTS} -MF"$BUILD_CONFIGURATION/cpp/ep_cascade_detector.d" -MT"$BUILD_CONFIGURATION/cpp/ep_cascade_detector.d" -o "$BUILD_CONFIGURATION/cpp/ep_cascade_detector.o" "cpp/ep_cascade_detector.cpp"
gcc -D__HOST__ -DDEVICE_EMULATION -I${HOST_INCLUDE} ${OPTS} -std=c99 -MF"$BUILD_CONFIGURATION/c/ep_cascade_detector.d" -MT"$BUILD_CONFIGURATION/c/ep_cascade_detector.d" -o "$BUILD_CONFIGURATION/c/ep_cascade_detector.o" "c/ep_cascade_detector.c"
gcc -D__HOST__ -DDEVICE_EMULATION -I${HOST_INCLUDE} ${OPTS} -std=c99 -MF"$BUILD_CONFIGURATION/c/ep_emulator.d" -MT"$BUILD_CONFIGURATION/c/ep_emulator.d" -o "$BUILD_CONFIGURATION/c/ep_emulator.o" "c/ep_emulator.c"
g++ -D__HOST__ -DDEVICE_EMULATION -I${HOST_INCLUDE} ${OPTS} -MF"$BUILD_CONFIGURATION/main.d" -MT"$BUILD_CONFIGURATION/main.d" -o "$BUILD_CONFIGURATION/main.o" "main.cpp"
g++ -z origin -fopenmp -o "$BUILD_CONFIGURATION/EpFaceHost_emul"  ./$BUILD_CONFIGURATION/cpp/ep_cascade_detector.o  ./$BUILD_CONFIGURATION/c/ep_cascade_detector.o ./$BUILD_CONFIGURATION/c/ep_emulator.o  ./$BUILD_CONFIGURATION/main.o   -lopencv_core -lopencv_highgui -lopencv_imgproc -lopencv_objdetect
cd - > /dev/null
echo "Done."
